#!/bin/bash

PWD="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

$PWD/check_enabled.sh
swapEnabled=$?

swapFile=/swap_memory
expectedSwapFileSize=200000

availableSystemMemory=`cat /proc/meminfo | grep MemAvailable | awk '{print $2}'`
if (( availableSystemMemory > expectedSwapFileSize )); then
    echo "no need for swap, system has enough memory"
    exit
fi

if [[ $swapEnabled = 0 ]]; then
    echo "swap already enabled. ignoring"
    exit
fi

echo "PWD: $PWD"
echo "swap status: $swapEnabled"
echo "swap disabled, enabling"

if [ -f "$swapFile" ]; then
    fileSize=`stat -c %s $swapFile`

    if [[ ! $fileSize = $expectedSwapFileSize ]]; then
        echo "swap file has unexpected size, removing"
        rm $swapFile
        dd if=/dev/zero of=$swapFile bs=1024 count=$expectedSwapFileSize
    fi
else
    dd if=/dev/zero of=$swapFile bs=1024 count=$expectedSwapFileSize
fi

chmod 0600 $swapFile
mkswap $swapFile
swapon $swapFile
